/*
 * Decompiled with CFR 0.152.
 */
package lib.toma.animations.api;

import lib.toma.animations.api.lifecycle.IRegistryEntry;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public final class AnimationStage
implements Comparable<AnimationStage>,
IRegistryEntry {
    private static int indexOffset;
    public static final AnimationStage ITEM_AND_HANDS;
    public static final AnimationStage RIGHT_HAND;
    public static final AnimationStage LEFT_HAND;
    public static final AnimationStage HANDS;
    public static final AnimationStage HELD_ITEM;
    private final int index = indexOffset++;
    private final ResourceLocation key;
    private final ITextComponent name;

    private AnimationStage(ResourceLocation key) {
        this.key = key;
        this.name = new TranslationTextComponent("animation.stage." + key.toString());
    }

    public static AnimationStage create(String name) {
        return AnimationStage.create(new ResourceLocation(name));
    }

    public static AnimationStage create(String namespace, String name) {
        return AnimationStage.create(new ResourceLocation(namespace, name));
    }

    public static AnimationStage create(ResourceLocation resourceLocation) {
        return new AnimationStage(resourceLocation);
    }

    public int getIndex() {
        return this.index;
    }

    @Override
    public ResourceLocation getKey() {
        return this.key;
    }

    public ITextComponent getName() {
        return this.name;
    }

    @Override
    public int compareTo(AnimationStage o) {
        return o.getIndex() - this.index;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AnimationStage stage = (AnimationStage)o;
        return this.index == stage.index;
    }

    public int hashCode() {
        return this.index;
    }

    public String toString() {
        return this.key.toString();
    }

    static {
        ITEM_AND_HANDS = AnimationStage.create("hands.item");
        RIGHT_HAND = AnimationStage.create("hands.right");
        LEFT_HAND = AnimationStage.create("hands.left");
        HANDS = AnimationStage.create("hands");
        HELD_ITEM = AnimationStage.create("item.heldfp");
    }
}

